<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    * 	Classe che restituisce i link scritti con Geecom
    *
    * Classe per gestire le api
    */
     
    class Api {
        private $db;
        private $id; // se io scrivo private significa che questa variabile è presente solo in questa classe
        private $attiva;
        private $nomeUtenza;
        private $codiceSegreto;
        private $permessiLettura;
        private $permessiScrittura;
        
        /* creo il costruttore, ovvero il metodo che crea il nostro oggetto */
        public function __construct($db, $id, $attiva="", $nomeUtenza="", $codiceSegreto="", $permessiLettura="", $permessiScrittura="") {
            $this->db = $db;
            $this->id = $id;
            $this->attiva = $attiva;
            $this->nomeUtenza = $nomeUtenza;
            $this->codiceSegreto = $codiceSegreto;
            $this->permessiLettura = $permessiLettura;
            $this->permessiScrittura = $permessiScrittura;
        }

        /*
         * metodo per la creazione della categoria
         */
        function crea() {
            $query = "INSERT INTO `geec_utenzeApi` (`id`, `attiva`, `nomeUtenza`, `codiceSegreto`, `permessiLettura`, `permessiScrittura`)
                        VALUES (NULL, '$this->attiva', '$this->nomeUtenza', '$this->codiceSegreto', '$this->permessiLettura', '$this->permessiScrittura');";
            $this->id = $this->db->eseguiQueryCreazione($query);
            
            return $this->id;
        }
        
        /*
         * qui va aggiunto un parametro alias che deve essere passato dall'utente
         */
        function modifica() {
            $query = "UPDATE `geec_utenzeApi` SET  attiva='$this->attiva', nomeUtenza='$this->nomeUtenza', codiceSegreto='$this->codiceSegreto', permessiLettura='$this->permessiLettura', permessiScrittura='$this->permessiScrittura' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_utenzeApi",$this->id);
        }
        
        function duplica($prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_utenzeApi WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_utenzeApi SELECT * FROM tabella_temporanea;");
            $idCategoriaDuplicata = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_utenzeApi SET nomeUtenza = CONCAT('$prefisso', ' ', nomeUtenza) WHERE id = $idCategoriaDuplicata");
            return $idCategoriaDuplicata;
        }
        
        function caricaDatiDalDatabase() {
            $datiCategoria           = $this->db->leggiSingolaRiga("geec_utenzeApi",$this->id);
            $this->attiva            = $datiCategoria["attiva"];
            $this->nomeUtenza        = $datiCategoria["nomeUtenza"];
            $this->codiceSegreto     = $datiCategoria["codiceSegreto"];
            $this->permessiLettura   = $datiCategoria["permessiLettura"];
            $this->permessiScrittura = $datiCategoria["permessiScrittura"];
        }
            
        // GETTER E SETTER
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getAttiva() {
            return $this->attiva;
        }

        public function getNomeUtenza() {
            return $this->nomeUtenza;
        }

        public function getCodiceSegreto() {
            return $this->codiceSegreto;
        }

        public function getPermessiLettura() {
            return $this->permessiLettura;
        }

        public function getPermessiScrittura() {
            return $this->permessiScrittura;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setAttiva($attiva): void {
            $this->attiva = $attiva;
        }

        public function setNomeUtenza($nomeUtenza): void {
            $this->nomeUtenza = $nomeUtenza;
        }

        public function setCodiceSegreto($codiceSegreto): void {
            $this->codiceSegreto = $codiceSegreto;
        }

        public function setPermessiLettura($permessiLettura): void {
            $this->permessiLettura = $permessiLettura;
        }

        public function setPermessiScrittura($permessiScrittura): void {
            $this->permessiScrittura = $permessiScrittura;
        }

    }